import os
import sys

# Path to the virtual environment
venv_path = '/home/tfduljaevi/myenv'

# Add the virtual environment's site-packages to the Python path
site_packages = os.path.join(venv_path, 'lib', 'python3.12', 'site-packages')
sys.path.insert(0, site_packages)

# Add the application directory to the Python path
project_path = '/home/tfduljaevi/womennigeria.org'
sys.path.insert(0, project_path)

# Set the DJANGO_SETTINGS_MODULE environment variable
os.environ['DJANGO_SETTINGS_MODULE'] = 'django_blerf.settings'  # Replace with your actual settings module

# Ensure the correct Python interpreter is used
python_interpreter = os.path.join(venv_path, 'bin', 'python3')
if os.path.exists(python_interpreter):
    sys.executable = python_interpreter

# Load the Django application
from django.core.wsgi import get_wsgi_application
application = get_wsgi_application()