from django.db import models
from django.contrib.auth.models import User
from django.shortcuts import reverse
import datetime
# Create your models here.
class Category(models.Model):
    name=models.TextField()

    def __str__(self):
        return self.name

class Comment(models.Model):
    user=models.ForeignKey(User, null=True,blank=True, on_delete=models.CASCADE)
    title=models.TextField()
    comment=models.TextField()

class Images(models.Model):
    title =models.TextField()
    image = models.ImageField()

    def __str__(self):
        return self.title

class Videos(models.Model):
    title =models.TextField()
    body = models.TextField()
    video = models.FileField()

    def __str__(self):
        return self.title

class Audio(models.Model):
    title =models.TextField()
    author =models.TextField()
    link =models.TextField()

    def __str__(self):
        return self.title


class UserProfile(models.Model):
    user = models.OneToOneField(User, related_name="profile", on_delete=models.CASCADE)
    username=models.CharField(max_length=100, null=True,blank=True)
    name= models.CharField(max_length=100)
    email=models.CharField(max_length=100)

    def __str__(self):
        return self.user.username

class Blog(models.Model):
    title=models.TextField()
    image=models.ManyToManyField(Images)
    summary= models.TextField()
    body=models.TextField()
    date=models.DateField()
    slug = models.SlugField()
    creator = models.ForeignKey(User, null=True,blank=True, on_delete=models.CASCADE)
    comment= models.ManyToManyField(Comment,null=True,blank=True,)
    category_list=["Accountant","Activism"
,"Actor"
,"Administration"
,"Agriculture"
,"Air Force"
,"architect"
,"Arts"
,"Author"
,"Aviation"
,"Banker"
,"Banking"
,"Broadcaster"
,"Businessman"
,"Civil Engineer"
,"Civil Service"
,"Clergy"
,"Computer/ IT"
,"Construction"
,"Consultant"
,"Diplomat"
,"Economist"
,"Educationist"
,"Engineer"
,"Engineering"
,"Entertainment"
,"Entrepreneur/Business"
,"Environmentalist"
,"Evangelist"
,"Farmer"
,"First Among Equals"
,"Footballer"
,"Geologist"
,"Government"
,"Historian"
,"In The News"
,"Industrialist"
,"Investment Banker"
,"Journalist"
,"Judge"
,"Lawyer"
,"Leadership"
,"Leadership Trainer"
,"Lecturer"
,"Legal"
,"Legislator"
,"Librarian"
,"Management Consultant"
,"Mathematician"
,"Media"
,"Mediator"
,"Medical Consultant"
,"Medicals/Nursing"
,"Menus"
,"Military"
,"Naval Officer"
,"Oceanographer"
,"Oil"
,"oil and gas"
,"Opinion"
,"Petroleum Engineer"
,"Pharmacist"
,"Pharmacy"
,"philanthropist"
,"Pilot"
,"Poet"
,"Police"
,"Political Scientist"
,"Politics"
,"Portfolio Manager"
,"Professional"
,"Professor"
,"Properties"
,"Public Service"
,"Real Estate"
,"Rising Stars"
,"Royalty"
,"Scholar"
,"Scientist"
,"Singer"
,"Sociologist"
,"Songwriter"
,"Sports"
,"Surgeon"
,"Teacher"
,"Telecommunications"
,"Telecommunications Consultant"
,"Tourism"
,"Uncategorized"
,"Writer"
,"Writer"
,"Zoologist"]
    CATEGORY_CHOICES = [("Acadmeia","Academia"),]
    for i in category_list:
        CATEGORY_CHOICES.append((i,i))
    category=models.CharField(max_length=100, choices=CATEGORY_CHOICES,default="None")
    paginate_by = 2
    def get_absolute_url(self):
        return reverse("APP:single_post", kwargs={
            'slug': self.slug
        })
    def __str__(self):
        return self.title

class Biography(models.Model):
    title=models.TextField(null=True,blank=True)
    name=models.TextField(null=True,blank=True)
    image=models.ManyToManyField(Images)
    created_at=models.DateField(auto_now_add=True)
    excerpt=models.TextField(null=True,blank=True)
    email=models.TextField(null=True,blank=True)
    facebook=models.TextField(null=True,blank=True)
    instagram=models.TextField(null=True,blank=True)
    twitter=models.TextField(null=True,blank=True)
    age=models.IntegerField(null=True,blank=True,editable=False)
    date_of_birth=models.DateField(null=True,blank=True)
    deceased=models.BooleanField(default=False)
    date_of_death=models.DateField(null=True,blank=True)
    place_of_birth=models.TextField(null=True,blank=True)
    father_name=models.TextField(null=True,blank=True)
    mother_name=models.TextField(null=True,blank=True)
    father_status=models.TextField(null=True,blank=True)
    mother_status=models.TextField(null=True,blank=True)
    marital_status=models.TextField(null=True,blank=True)
    date_married=models.DateField(null=True,blank=True)
    name_of_spouse=models.TextField(null=True,blank=True)
    name_of_children=models.TextField(null=True,blank=True)
    no_of_male_child=models.IntegerField(null=True,blank=True)
    no_of_female_child=models.IntegerField(null=True,blank=True)
    working_experience=models.TextField(null=True,blank=True)
    profession=models.TextField()
    phone=models.TextField(null=True,blank=True)
    mobile=models.TextField(null=True,blank=True)
    address=models.TextField(null=True,blank=True)
    primary_education=models.TextField(null=True,blank=True)
    secondary_education=models.TextField(null=True,blank=True)
    tetiary_education=models.TextField(null=True,blank=True)
    education_qualification_and_date=models.TextField(null=True,blank=True)
    academic_honours=models.TextField(null=True,blank=True)
    memberships=models.TextField(null=True,blank=True)
    present_appointment=models.TextField(null=True,blank=True)
    previous_appointment=models.TextField(null=True,blank=True)
    political_member_choice=models.TextField(null=True,blank=True)
    political_party=models.TextField(null=True,blank=True)
    int_membership=models.TextField(null=True,blank=True)
    traditional_titles=models.TextField(null=True,blank=True)
    national_honours=models.TextField(null=True,blank=True)
    international_decors=models.TextField(null=True,blank=True)
    creative_work_or_major_exhibitions=models.TextField(null=True,blank=True)
    honorary_degrees_and_institution=models.TextField(null=True,blank=True)
    achievment=models.TextField(null=True,blank=True)
    motiv_lit=models.TextField(null=True,blank=True)
    role_model=models.TextField(null=True,blank=True)
    quotes=models.TextField(null=True,blank=True)
    hobbies=models.TextField(null=True,blank=True)
    social_club=models.TextField(null=True,blank=True)
    others=models.TextField(null=True,blank=True)
    category_list=["Accountant","Activism"
,"Actor"
,"Administration"
,"Agriculture"
,"Air Force"
,"architect"
,"Arts"
,"Author"
,"Aviation"
,"Banker"
,"Banking"
,"Broadcaster"
,"Businessman"
,"Civil Engineer"
,"Civil Service"
,"Clergy"
,"Computer/ IT"
,"Construction"
,"Consultant"
,"Diplomat"
,"Economist"
,"Educationist"
,"Engineer"
,"Engineering"
,"Entertainment"
,"Entrepreneur/Business"
,"Environmentalist"
,"Evangelist"
,"Farmer"
,"First Among Equals"
,"Footballer"
,"Geologist"
,"Government"
,"Historian"
,"In The News"
,"Industrialist"
,"Investment Banker"
,"Journalist"
,"Judge"
,"Lawyer"
,"Leadership"
,"Leadership Trainer"
,"Lecturer"
,"Legal"
,"Legislator"
,"Librarian"
,"Management Consultant"
,"Mathematician"
,"Media"
,"Mediator"
,"Medical Consultant"
,"Medicals/Nursing"
,"Menus"
,"Military"
,"Naval Officer"
,"Oceanographer"
,"Oil"
,"oil and gas"
,"Opinion"
,"Petroleum Engineer"
,"Pharmacist"
,"Pharmacy"
,"philanthropist"
,"Pilot"
,"Poet"
,"Police"
,"Political Scientist"
,"Politics"
,"Portfolio Manager"
,"Professional"
,"Professor"
,"Properties"
,"Public Service"
,"Real Estate"
,"Rising Stars"
,"Royalty"
,"Scholar"
,"Scientist"
,"Singer"
,"Sociologist"
,"Songwriter"
,"Sports"
,"Surgeon"
,"Teacher"
,"Telecommunications"
,"Telecommunications Consultant"
,"Tourism"
,"Uncategorized"
,"Writer"
,"Writer"
,"Zoologist"]
    CATEGORY_CHOICES = [("Acadmeia","Academia"),]
    for i in category_list:
        CATEGORY_CHOICES.append((i,i))
    category=models.CharField(max_length=100, choices=CATEGORY_CHOICES)
    approved=models.BooleanField(default=False)
    paginate_by = 2
    slug = models.SlugField(unique=True)
    def get_absolute_url(self):
        return reverse("APP:single", kwargs={
            'slug': self.slug
        })
    def save(self):
        self.age = int(datetime.datetime.now().year)-int(self.date_of_birth.year)
        super(Biography, self).save()
    def __str__(self):
        return self.name

class NewsLetter(models.Model):
    email=models.TextField()
    def __str__(self):
        return self.email


class Reply(models.Model):
    blog=models.TextField()
    user=models.ForeignKey(User, null=True,blank=True, on_delete=models.CASCADE)
    reply=models.TextField()
    paginate_by = 2

class History(models.Model):
    title=models.TextField()
    date=models.DateField()
    body=models.TextField()

    def __str__(self):
        return self.title

class Donations(models.Model):
    target=models.TextField()
    date=models.DateField()
    percent=models.IntegerField()
    title=models.TextField()
    image=models.ManyToManyField(Images)
    link=models.CharField(max_length=200)

    def __str__(self):
        return self.title

class Participant(models.Model):
    name=models.TextField()
    image=models.ImageField()

    def __str__(self):
        return self.name

class Event(models.Model):
    date=models.DateTimeField()
    title=models.TextField()
    summary=models.TextField()
    body=models.TextField()
    image=models.ManyToManyField(Images)
    address=models.TextField()
    start_time=models.TextField()
    finish_time=models.TextField()
    partcipants=models.ManyToManyField(Participant)
    day=models.IntegerField()
    slug=models.SlugField()

    def get_absolute_url(self):
        return reverse("APP:single_event", kwargs={
            'slug': self.slug
        })

    def __str__(self):
        return self.title
