import os
import subprocess
import sys

# Define paths
venv_path = '/home/tfduljaevi/myenv'  # Path to the virtual environment
requirements_path = '/home/tfduljaevi/womennigeria.org/requirements.txt'  # Path to the requirements.txt file

# Step 1: Create the virtual environment if it doesn't exist
if not os.path.exists(venv_path):
    print(f"Creating virtual environment at {venv_path}...")
    subprocess.check_call([sys.executable, '-m', 'venv', venv_path])
else:
    print(f"Virtual environment already exists at {venv_path}")

# Step 2: Install dependencies from requirements.txt
pip_path = os.path.join(venv_path, 'bin', 'pip')  # Path to pip inside the virtual environment
if os.path.exists(requirements_path):
    print(f"Installing dependencies from {requirements_path}...")
    subprocess.check_call([pip_path, 'install', '-r', requirements_path])
else:
    print(f"requirements.txt not found at {requirements_path}")

print("Setup complete.")