from django.shortcuts import render,redirect
from django.contrib.auth.models import User, auth
from .models import UserProfile,Biography,Blog,NewsLetter,Reply,History,Donations,Videos,Images,Audio,Event,Category
from django.views.generic import ListView, DetailView, View
import smtplib
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from django.db.models import Q
from django.core.paginator import Paginator
import time
import datetime
from datetime import timezone


items=["Academia","Accountant","Activism"
,"Actor"
,"Administration"
,"Agriculture"
,"Air Force"
,"architect"
,"Arts"
,"Author"
,"Aviation"
,"Banker"
,"Banking"
,"Broadcaster"
,"Businessman"
,"Civil Engineer"
,"Civil Service"
,"Clergy"
,"Computer/ IT"
,"Construction"
,"Consultant"
,"Diplomat"
,"Economist"
,"Educationist"
,"Engineer"
,"Engineering"
,"Entertainment"
,"Entrepreneur/Business"
,"Environmentalist"
,"Evangelist"
,"Farmer"
,"First Among Equals"
,"Footballer"
,"Geologist"
,"Government"
,"Historian"
,"In The News"
,"Industrialist"
,"Investment Banker"
,"Journalist"
,"Judge"
,"Lawyer"
,"Leadership"
,"Leadership Trainer"
,"Lecturer"
,"Legal"
,"Legislator"
,"Librarian"
,"Management Consultant"
,"Mathematician"
,"Media"
,"Mediator"
,"Medical Consultant"
,"Medicals/Nursing"
,"Menus"
,"Military"
,"Naval Officer"
,"Oceanographer"
,"Oil"
,"oil and gas"
,"Opinion"
,"Petroleum Engineer"
,"Pharmacist"
,"Pharmacy"
,"philanthropist"
,"Pilot"
,"Poet"
,"Police"
,"Political Scientist"
,"Politics"
,"Portfolio Manager"
,"Professional"
,"Professor"
,"Properties"
,"Public Service"
,"Real Estate"
,"Rising Stars"
,"Royalty"
,"Scholar"
,"Scientist"
,"Singer"
,"Sociologist"
,"Songwriter"
,"Sports"
,"Surgeon"
,"Teacher"
,"Telecommunications"
,"Telecommunications Consultant"
,"Tourism"
,"Uncategorized"
,"Writer"
,"Writer"
,"Zoologist"]

for i in items:
    i.replace(" ","_")
    i.replace("/","_")
    if Category.objects.filter(name=i):
        pass
    else:
        Category.objects.create(name=i)

# Create your views here.
class IndexListView(ListView):
    model = Biography
    template_name = "index.html"
    queryset= Biography.objects.filter(approved=True)
    def get_context_data(self, **kwargs):
        context = super(IndexListView, self).get_context_data(**kwargs)
        if self.request.GET.get('sub')=="true":
            email=self.request.GET.get('email')
            check_email=NewsLetter.objects.filter(email=email)
            if check_email.exists():
                context['message']=' This Email is Subscribed Already'
            else:
                news=NewsLetter.objects.create(email=email)
                news.save()
                context['message']="Thank you for subscribing to Blerf's Women's Who"
                fromaddr = "info@blerf.org"
                toaddr = email
                subject="Newsletter Subscription"
                msg = MIMEMultipart()
                msg['From'] = fromaddr
                msg['To'] = toaddr
                msg['Subject'] = subject


                body = "You have successfully subscribed to our Newsletter..Join prominent women in Nigeria today by registering on our website http://35.193.153.182/ "
                msg.attach(MIMEText(body, 'plain'))

                server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
                server.ehlo()
                server.starttls()
                server.ehlo()
                server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
                text = msg.as_string()
                server.sendmail(fromaddr, toaddr, text)

        context['bios'] = Biography.objects.filter(category__icontains="Politics",approved=True)[:6]
        context['bios2'] = Biography.objects.filter(category__icontains="Entertainment",approved=True)[:6]
        context['bios3'] = Biography.objects.filter(category__icontains="Education",approved=True)[:6]
        context['bios4'] = Biography.objects.filter(category__icontains="Tech",approved=True)[:6]
        context['bios5'] = Biography.objects.filter(category__icontains="Public",approved=True)[:6]
        context['bios6'] = Biography.objects.filter(category__icontains="Rising",approved=True)[:6]
        context['blog'] = Blog.objects.all()[0:3]
        context['blogs'] = Blog.objects.all()[0:4]
        context["events"]=Event.objects.filter(Q(date__range=(datetime.datetime.now()-datetime.timedelta(days=1),datetime.datetime.now()))).order_by("-date")[:2]
        context["middle"]=Event.objects.filter(Q(date__range=(datetime.datetime.now()-datetime.timedelta(days=1),datetime.datetime.now()))).order_by("-date")[2:4]
        return context


def about(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    return render(request,"about-university.html")

def about_prof(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    return render(request,"about-nyaknno-osso.html")

def contact(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.method=="POST":
        name=request.POST['name']
        email=request.POST['email']
        phone=request.POST['phone']
        message=request.POST['message']
        fromaddr = "info@blerf.org"
        toaddr = "e-library@advancescholar.com"
        subject=email + " needs assistance"
        msg = MIMEMultipart()
        msg['From'] = fromaddr
        msg['To'] = toaddr
        msg['Subject'] = subject


        body = message
        msg.attach(MIMEText(body, 'plain'))

        server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
        server.ehlo()
        server.starttls()
        server.ehlo()
        server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
        text = msg.as_string()
        server.sendmail(fromaddr, toaddr, text)
        context={'message':'Your message has been sent sucessfully'}
        return render(request, 'contact-us.html',context)
    return render(request, 'contact-us.html')


class BlogDetailView(DetailView):
    model= Blog
    template_name="single-post.html"
    def get_context_data(self, **kwargs):
        context = super(BlogDetailView, self).get_context_data(**kwargs)
        if self.request.GET.get('sub')=="true":
            email=self.request.GET.get('email')
            check_email=NewsLetter.objects.filter(email=email)
            if check_email.exists():
                context['message']=' This Email is Subscribed Already'
            else:
                news=NewsLetter.objects.create(email=email)
                news.save()
                context['message']="Thank you for subscribing to Blerf's Women's Who"
                fromaddr = "info@blerf.org"
                toaddr = email
                subject="Newsletter Subscription"
                msg = MIMEMultipart()
                msg['From'] = fromaddr
                msg['To'] = toaddr
                msg['Subject'] = subject


                body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
                msg.attach(MIMEText(body, 'plain'))

                server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
                server.ehlo()
                server.starttls()
                server.ehlo()
                server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
                text = msg.as_string()
                server.sendmail(fromaddr, toaddr, text)
        return context

class BioDetailView(DetailView):
    model=Biography
    template_name="single.html"
    def get_context_data(self, **kwargs):
        context = super(BioDetailView, self).get_context_data(**kwargs)
        if self.request.GET.get('sub')=="true":
            email=self.request.GET.get('email')
            check_email=NewsLetter.objects.filter(email=email)
            if check_email.exists():
                context['message']=' This Email is Subscribed Already'
            else:
                news=NewsLetter.objects.create(email=email)
                news.save()
                context['message']="Thank you for subscribing to Blerf's Women's Who"
                fromaddr = "info@blerf.org"
                toaddr = email
                subject="Newsletter Subscription"
                msg = MIMEMultipart()
                msg['From'] = fromaddr
                msg['To'] = toaddr
                msg['Subject'] = subject


                body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
                msg.attach(MIMEText(body, 'plain'))

                server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
                server.ehlo()
                server.starttls()
                server.ehlo()
                server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
                text = msg.as_string()
                server.sendmail(fromaddr, toaddr, text)

        return context

class BlogListView(ListView):
    model=Blog
    template_name="blog.html"
    def get_context_data(self, **kwargs):
        context = super(BlogListView, self).get_context_data(**kwargs)
        blog={}
        if self.request.GET.get('sub')=="true":
            email=self.request.GET.get('email')
            check_email=NewsLetter.objects.filter(email=email)
            if check_email.exists():
                context['message']=' This Email is Subscribed Already'
            else:
                news=NewsLetter.objects.create(email=email)
                news.save()
                context['message']="Thank you for subscribing to Blerf's Women's Who"
                fromaddr = "info@blerf.org"
                toaddr = email
                subject="Newsletter Subscription"
                msg = MIMEMultipart()
                msg['From'] = fromaddr
                msg['To'] = toaddr
                msg['Subject'] = subject


                body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
                msg.attach(MIMEText(body, 'plain'))

                server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
                server.ehlo()
                server.starttls()
                server.ehlo()
                server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
                text = msg.as_string()
                server.sendmail(fromaddr, toaddr, text)
        if self.request.GET.get('check_cat')=="true":
            category=self.request.GET.get("category")
            blog=Blog.objects.filter(category__icontains=category).order_by("title")
        
        if blog:
            context['page_obj'] = blog
        else:
            paginator= Paginator(Blog.objects.all(),10)
            page_number = self.request.GET.get('page')
            page_obj = paginator.get_page(page_number)
            context['page_obj'] = page_obj
        context['blog'] = Blog.objects.all()
        context["cat"] = Category.objects.all().distinct()
        return context



class BioListView(ListView):
    model=Biography
    template_name="bio.html"
    def get_context_data(self, **kwargs):
        context = super(BioListView, self).get_context_data(**kwargs)
        bio=''
        if self.request.GET.get('search'):
            search=self.request.GET.get('search')
            check_bio=Biography.objects.filter(name__icontains=search,approved=True)
            check_blog=Blog.objects.filter(title__icontains=search)
            if check_bio or check_blog:
                context["search_bio"]=check_bio
                context["search_blog"]=check_blog
            else:
                context["search_bio"]=""
                context["search_blog"]=""
        if self.request.GET.get('report')=="true":
            arrange=self.request.GET.get('arrange')
            if arrange=="alpha":
                bio=Biography.objects.filter(approved=True).order_by("name")
            elif arrange=="age":
                bio=Biography.objects.filter(approved=True).order_by("age")
            elif arrange=="career":
                bio=Biography.objects.filter(approved=True).order_by("profession")
        if self.request.GET.get('check_alpha')=="true":
            name=self.request.GET.get("name")
            bio=Biography.objects.filter(name__startswith=name,approved=True).order_by("name")
        if self.request.GET.get('check_cat')=="true":
            category=self.request.GET.get("category")
            bio=Biography.objects.filter(Q(category__icontains=category,approved=True) |Q(profession__icontains=category,approved=True)).order_by("profession")
        if self.request.GET.get('sub')=="true":
            email=self.request.GET.get('email')
            check_email=NewsLetter.objects.filter(email=email)
            if check_email.exists():
                context['message']=' This Email is Subscribed Already'
            else:
                news=NewsLetter.objects.create(email=email)
                news.save()
                context['message']="Thank you for subscribing to Blerf's Women's Who"
                fromaddr = "info@blerf.org"
                toaddr = email
                subject="Newsletter Subscription"
                msg = MIMEMultipart()
                msg['From'] = fromaddr
                msg['To'] = toaddr
                msg['Subject'] = subject


                body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
                msg.attach(MIMEText(body, 'plain'))

                server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
                server.ehlo()
                server.starttls()
                server.ehlo()
                server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
                text = msg.as_string()
                server.sendmail(fromaddr, toaddr, text)

        context["cat"] = Category.objects.all().distinct()
        if bio=='':
            paginator= Paginator(Biography.objects.filter(approved=True),10)
            page_number = self.request.GET.get('page')
            page_obj = paginator.get_page(page_number)
            context['page_obj'] = page_obj
        else:
            paginator= Paginator(bio,10)
            page_number = self.request.GET.get('page')
            page_obj = paginator.get_page(page_number)
            context['page_obj'] = page_obj
        return context

class Bio2ListView(ListView):
    model=Biography
    template_name="bio-list.html"
    def get_context_data(self, **kwargs):
        context = super(Bio2ListView, self).get_context_data(**kwargs)
        bio=''
        if self.request.GET.get('search'):
            search=self.request.GET.get('search')
            check_bio=Biography.objects.filter(name__icontains=search,approved=True)
            check_blog=Blog.objects.filter(title__icontains=search)
            if check_bio or check_blog:
                context["search_bio"]=check_bio
                context["search_blog"]=check_blog
            else:
                context["search_bio"]=""
                context["search_blog"]=""
        if self.request.GET.get('report')=="true":
            arrange=self.request.GET.get('arrange')
            if arrange=="alpha":
                bio=Biography.objects.filter(approved=True).order_by("name")
            elif arrange=="age":
                bio=Biography.objects.filter(approved=True).order_by("age")
            elif arrange=="career":
                bio=Biography.objects.filter(approved=True).order_by("profession")
        if self.request.GET.get('sub')=="true":
            email=self.request.GET.get('email')
            check_email=NewsLetter.objects.filter(email=email)
            if check_email.exists():
                context['message']=' This Email is Subscribed Already'
            else:
                news=NewsLetter.objects.create(email=email)
                news.save()
                context['message']="Thank you for subscribing to Blerf's Women's Who"
                fromaddr = "info@blerf.org"
                toaddr = email
                subject="Newsletter Subscription"
                msg = MIMEMultipart()
                msg['From'] = fromaddr
                msg['To'] = toaddr
                msg['Subject'] = subject


                body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
                msg.attach(MIMEText(body, 'plain'))

                server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
                server.ehlo()
                server.starttls()
                server.ehlo()
                server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
                text = msg.as_string()
                server.sendmail(fromaddr, toaddr, text)

        context["cat"] = Category.objects.all().distinct()
        if bio=='':
            paginator= Paginator(Biography.objects.filter(approved=True),10)
            page_number = self.request.GET.get('page')
            page_obj = paginator.get_page(page_number)
            context['page_obj'] = page_obj
        else:
            paginator= Paginator(bio,10)
            page_number = self.request.GET.get('page')
            page_obj = paginator.get_page(page_number)
            context['page_obj'] = page_obj
        return context


def signup(request):
    if request.method=="POST":
        name=request.POST.get("name")
        email=request.POST.get("email")
        username=request.POST.get("username")
        password1=request.POST.get("password1")
        password2=request.POST.get("password2")
        if password1 == password2:
                if User.objects.filter(email=email).exists():

                    return render(request, 'signup.html')
                else:
                    user = User.objects.create(
                        username=username, password=password1, email=email)
                    user.set_password(user.password)
                    user.save()
                    profile=UserProfile.objects.create(user=user,
                        username=username, name=name, email=email)
                    profile.save()
                    return redirect(request,'login.html')
        else:
            context={"message":"incorrect details"}
            return render(request,'signup.html',context)
    return render(request,"signup.html")

def login(request):
    if request.method=="POST":
        username=request.POST.get("username")
        password=request.POST.get("password")
        user = auth.authenticate(username=username, password=password)
        if user is not None:
            auth.login(request, user)
            return redirect("index.html")
        else:
            return render(request, 'login.html', {"message": "The user does not exist"})
    else:
        return render(request,'login.html')

def add_bio(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.method=="POST":
        title=request.POST.get("title")
        name=request.POST.get("name")
        image=request.FILES.get("image")
        date_of_birth=request.POST.get("dob")
        age=int(datetime.datetime.now().year)-int(date_of_birth[:3])
        place_of_birth=request.POST.get("pob")
        father=request.POST.get("father")
        mother=request.POST.get("mother")
        father_status=request.POST.get("father_status")
        mother_status=request.POST.get("mother_status")
        marital_status=request.POST.get("marital_status")
        date_married=request.POST.get("date_married")
        name_spouse=request.POST.get("name_spouse")
        name_children=request.POST.get("name_children")
        female_child=request.POST.get("female_child")
        male_child=request.POST.get("male_child")
        if female_child:
            female_child=int(request.POST.get("female_child"))
        else:
            female_child=0
        if male_child:
            male_child=int(request.POST.get("male_child"))
        else:
            male_child=0
        new=name.replace(" ","")
        if image:
            pass
        else:
            image='/var/www/html/media/def_image.png'
        global slug
        slug=new.replace("-","")
        request.session["slug"]=slug
        if Biography.objects.filter(name=name,date_of_birth=date_of_birth).exists():
            return render(request,"add-bio.html",{"message":"Biography Already Exists"})
        else:
            if name:
                bio=Biography.objects.create(title=title,name=name,age=age,date_of_birth=date_of_birth,place_of_birth=place_of_birth,father_name=father,mother_name=mother,father_status=father_status,mother_status=mother_status,marital_status=marital_status,date_married=date_married,name_of_spouse=name_spouse,name_of_children=name_children,no_of_male_child=male_child,no_of_female_child=female_child,slug=slug)
                bio.save()
                new_image=Images.objects.create(title=name,image=image)
                new_image.save()
                bio.image.add(new_image)
                return redirect("add-bio2.html")
            else:
                return render(request,"add-bio.html",{"message":"no title"})
    return render(request,"add-bio.html")

def add_bio2(request):
    global slug
    slug=request.session["slug"]
    bio=Biography.objects.get(slug=slug)
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.method=="POST":
        bio.facebook=request.POST.get("fb")
        bio.twitter=request.POST.get("tw")
        bio.instagram=request.POST.get("ig")
        bio.email=request.POST.get("email")
        bio.profession=request.POST.get("profession")
        bio.phone=request.POST.get("phone")
        bio.mobile=request.POST.get("mobile")
        bio.address=request.POST.get("address")
        bio.working_experience=request.POST.get("working_experience")
        bio.category=request.POST.get("category")
        bio.save()
        return redirect("add-bio3.html")
    context={"cat":Category.objects.all()}
    return render(request,"add-bio2.html",context)

def add_bio3(request):
    global slug
    slug=request.session["slug"]
    bio=Biography.objects.get(slug=slug)
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.method=="POST":
        bio.primary_education=request.POST.get("primary_edu")
        bio.secondary_education=request.POST.get("secondary_edu")
        bio.tetiary_education=request.POST.get("tetiary_edu")
        bio.education_qualification_and_date=request.POST.get("edu_and_date")
        bio.academic_honours=request.POST.get("academic_honours")
        bio.save()
        return redirect("add-bio4.html")
    return render(request,"add-bio3.html")

def add_bio4(request):
    global slug
    slug=request.session["slug"]
    bio=Biography.objects.get(slug=slug)
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.method=="POST":
        bio.memberships=request.POST.get("memberships")
        bio.present_appointment=request.POST.get("present_appoint")
        bio.previous_appointment=request.POST.get("previous_appoint")
        bio.political_party=request.POST.get("party")
        bio.int_membership=request.POST.get("int_membership")
        bio.traditional_titles=request.POST.get("trad_titles")
        bio.creative_work_or_major_exhibitions=request.POST.get("creative_work")
        bio.international_decors=request.POST.get("int_decors")
        bio.honorary_degrees_and_institution=request.POST.get("hon_and_institution")
        bio.achievment=request.POST.get("achievment")
        bio.national_honours=request.POST.get("nat_honours")
        bio.save()
        return redirect("add-bio5.html")
    return render(request,"add-bio4.html")

def add_bio5(request):
    global slug
    slug=request.session["slug"]
    bio=Biography.objects.get(slug=slug)
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.method=="POST":
        bio.motiv_lit=request.POST.get("motiv_lit")
        bio.role_model=request.POST.get("role_model")
        bio.quotes=request.POST.get("quotes")
        bio.hobbies=request.POST.get("hobbies")
        bio.age=request.POST.get("age")
        bio.social_club=request.POST.get("social_club")
        bio.others=request.POST.get("others")
        bio.save()
        return render(request,"add-bio5.html",{"message":"Saved Information To Bio Successfully"})
    return render(request,"add-bio5.html")

def search_complete(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.GET.get("tenth_check")=="ten":
        query=request.GET.get("search")
        if query:
            search = Biography.objects.filter(Q(name__icontains=query,approved=True))
            find=Blog.objects.filter(Q(title__icontains=query,approved=True))
            context={"search":search,"find":find,"query":query}
            return render(request,"search-complete.html",context)
        else:
            search = Biography.objects.none()
            find=Blog.objects.none()
            context={"search":search,"find":find}
            return render(request,"search-complete.html",context)
    return render(request,"search-complete.html")

def comment(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    if request.GET.get("comment")=="true":
        title=request.GET.get("title")
        if title:
            paginator= Paginator(Reply.objects.filter(blog=title),10)
            page_number = request.GET.get('page')
            page_obj = paginator.get_page(page_number)
            context={"page_obj":page_obj}
            return render(request,"comment.html",context)
        else:
            search = Reply.objects.none()
            context={"search":search}
            return render(request,"comment.html",context)
    return render(request,"comment.html")

def history(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    context={"history":History.objects.all()}
    return render(request,"history-timeline.html",context)


def team(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    return render(request,"our-team.html")

def donations(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    page_number = request.GET.get('page')
    paginator= Paginator(Donations.objects.all(),10)
    page_obj = paginator.get_page(page_number)
    context={"donations":Donations.objects.all(),"page_obj":page_obj}
    return render(request,"donations.html",context)

def multimedia(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()
            context['message']="Thank you for subscribing to Blerf's Women's Who"
            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    context={"videos":Videos.objects.all()[:3],"videos_top":Videos.objects.all()[4:5],"images_top":Images.objects.all()[:7],"images":Images.objects.all()[7:14],"images_buttom":Images.objects.all()[14:21],"audios":Audio.objects.all()[:2],"audios_last":Audio.objects.all()[3:]}
    return render(request,"multimedia.html",context)

def events(request):
    context={"events":Event.objects.filter(Q(date__gte=datetime.datetime.now()-datetime.timedelta(days=1),date__lte=datetime.datetime.now())),"events_middle":Event.objects.filter(Q(date__gte=datetime.datetime.now()+datetime.timedelta(days=1),date__lte=datetime.datetime.now()+datetime.timedelta(days=14))),"events_last":Event.objects.filter(Q(date__lte=datetime.datetime.now()-datetime.timedelta(days=2),date__gte=datetime.datetime.now()-datetime.timedelta(days=14)))}
    return render(request,"events.html",context)

class EventDetailView(DetailView):
    model=Event
    template_name="event-details.html"
    def get_context_data(self, **kwargs):
        context = super(EventDetailView, self).get_context_data(**kwargs)

        return context

def tools(request):
    if request.GET.get('sub')=="true":
        email=request.GET.get('email')
        check_email=NewsLetter.objects.filter(email=email)
        if check_email.exists():
            context['message']=' This Email is Subscribed Already'
        else:
            news=NewsLetter.objects.create(email=email)
            news.save()

            fromaddr = "info@blerf.org"
            toaddr = email
            subject="Newsletter Subscription"
            msg = MIMEMultipart()
            msg['From'] = fromaddr
            msg['To'] = toaddr
            msg['Subject'] = subject


            body = "You have successfully subscribed to our Newsletter..Look Up our website @ www.blerf.advancescholar.com and start Using our books "
            msg.attach(MIMEText(body, 'plain'))

            server = smtplib.SMTP('smtp-relay.sendinblue.com',  587)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login("Chukslord1@gmail.com", "N27RMafQ0TvqBG6H")
            text = msg.as_string()
            server.sendmail(fromaddr, toaddr, text)
    return render(request,"departments.html")

def logout(request):
    auth.logout(request)
    return redirect("index.html")
