import os
from django.conf import settings
from django.conf.urls.static import static
from django.urls import path, include
from . import views

app_name = "APP"
urlpatterns = [
    path("", views.IndexListView.as_view(), name="index"),
    path("index.html", views.IndexListView.as_view(), name="index"),
    path("about-us.html", views.about, name="about"),
    path("about-nyaknno-osso.html", views.about_prof, name="about_prof"),
    path("contact.html", views.contact, name="contact"),
    path("single-post.html/<slug>", views.BlogDetailView.as_view(), name="single_post"),
    path("single-event.html/<slug>", views.EventDetailView.as_view(), name="single_event"),
    path("single.html/<slug>", views.BioDetailView.as_view(), name="single"),
    path("blog.html", views.BlogListView.as_view(), name="blog"),
    path("biographies.html", views.BioListView.as_view(), name="bio"),
    path("bio-list.html", views.Bio2ListView.as_view(), name="bio-list"),
    path("signup", views.signup, name="signup"),
    path("login.html", views.login, name="login"),
    path("logout.html", views.logout, name="logout"),
    path("questionaire.html", views.add_bio, name="add_bio"),
    path("add-bio2.html", views.add_bio2, name="add_bio2"),
    path("add-bio3.html", views.add_bio3, name="add_bio3"),
    path("add-bio4.html", views.add_bio4, name="add_bio4"),
    path("add-bio5.html", views.add_bio5, name="add_bio5"),
    path("search-complete.html", views.search_complete, name="search_complete"),
    path("comment.html", views.comment, name="comment"),
    path("history-timeline.html", views.history, name="history-timeline"),
    path("team.html", views.team, name="team"),
    path("donations.html", views.donations, name="donations"),
    path("multimedia.html", views.multimedia, name="multimedia"),
    path("tools.html", views.tools, name="tools"),
    path("events.html", views.events, name="events"),





]
